/*
 * Decompiled with CFR 0.152.
 */
package net.zekromaster.minecraft.terminal.capabilities;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.class_124;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.util.Identifier;
import org.jetbrains.annotations.Nullable;

public final class ItemCapability<T, CTX> {
    final Multimap<class_124, ItemCapabilityHandler<T, CTX>> handlers = ArrayListMultimap.create();
    public final Identifier identifier;
    public final Class<T> clazz;
    public final Class<CTX> ctxClass;

    private ItemCapability(Identifier identifier, Class<T> clazz, Class<CTX> ctxClass) {
        this.identifier = identifier;
        this.clazz = clazz;
        this.ctxClass = ctxClass;
    }

    public static <T, CTX> ItemCapability<T, CTX> create(Identifier identifier, Class<T> clazz, Class<CTX> ctxClass) {
        return new ItemCapability<T, CTX>(identifier, clazz, ctxClass);
    }

    public static <T> ItemCapability<T, Void> createVoid(Identifier identifier, Class<T> clazz) {
        return new ItemCapability<T, Void>(identifier, clazz, Void.class);
    }

    @Nullable
    public T get(class_31 itemStack, CTX ctx) {
        for (ItemCapabilityHandler handler : this.handlers.get((Object)itemStack.method_694())) {
            Object value = handler.get(itemStack, ctx);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @FunctionalInterface
    public static interface ItemCapabilityHandler<T, CTX> {
        public T get(class_31 var1, CTX var2);
    }
}

