/*
 * Decompiled with CFR 0.152.
 */
package net.zekromaster.minecraft.terminal.mixin.attachments;

import java.util.Map;
import net.minecraft.class_187;
import net.minecraft.class_31;
import net.minecraft.class_8;
import net.modificationstation.stationapi.mixin.nbt.NbtCompoundAccessor;
import net.zekromaster.minecraft.terminal.attachments.AttachmentType;
import net.zekromaster.minecraft.terminal.attachments.inject.AttachmentsInjectedStore;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={class_31.class})
public abstract class ItemStackMixin
implements AttachmentsInjectedStore {
    @Override
    @Nullable
    public <T> T getDataOrNull(AttachmentType<T> attachmentType) {
        if (attachmentType.nbtCodec == null) {
            throw new IllegalStateException("Attempted to read attachment without NBT Codec on ItemStack");
        }
        class_8 nbt = ((class_31)this).getStationNbt().method_1033("attachments");
        Map nbtEntries = ((NbtCompoundAccessor)nbt).stationapi$getEntries();
        if (nbtEntries.containsKey(attachmentType.identifier.toString())) {
            return attachmentType.nbtCodec.fromNbt((class_187)nbtEntries.get(attachmentType.identifier.toString()));
        }
        return null;
    }

    @Override
    public <T> void setData(AttachmentType<T> attachmentType, T data) {
        if (attachmentType.nbtCodec == null) {
            throw new IllegalStateException("Attempted to add attachment without NBT Codec on ItemStack");
        }
        class_8 nbt = ((class_31)this).getStationNbt();
        class_8 attachments = nbt.method_1033("attachments");
        class_187 individualAttachment = attachmentType.nbtCodec.toNbt(data);
        attachments.method_1017(attachmentType.identifier.toString(), individualAttachment);
        nbt.method_1018("attachments", attachments);
    }

    @Override
    public boolean hasData(AttachmentType<?> attachmentType) {
        return ((NbtCompoundAccessor)((class_31)this).getStationNbt().method_1033("attachments")).stationapi$getEntries().containsKey(attachmentType.identifier.toString());
    }
}

