/*
 * Decompiled with CFR 0.152.
 */
package net.zekromaster.minecraft.terminal.nbt;

import net.minecraft.class_187;
import net.minecraft.class_273;
import net.minecraft.class_347;
import net.minecraft.class_358;
import net.minecraft.class_360;
import net.minecraft.class_419;
import net.minecraft.class_462;
import net.minecraft.class_522;
import net.zekromaster.minecraft.terminal.nbt.NbtDecoder;
import net.zekromaster.minecraft.terminal.nbt.NbtEncoder;
import org.jetbrains.annotations.NotNull;

public final class NbtCodec<T>
implements NbtDecoder<T, class_187>,
NbtEncoder<T, class_187> {
    public static final NbtCodec<Byte> BYTE = NbtCodec.create(class_360.class, class_360::new, x -> x.field_1356);
    public static final NbtCodec<Short> SHORT = NbtCodec.create(class_462.class, class_462::new, x -> x.field_1770);
    public static final NbtCodec<Integer> INT = NbtCodec.create(class_347.class, class_347::new, x -> x.field_1312);
    public static final NbtCodec<Long> LONG = NbtCodec.create(class_273.class, class_273::new, x -> x.field_1122);
    public static final NbtCodec<Float> FLOAT = NbtCodec.create(class_358.class, class_358::new, x -> Float.valueOf(x.field_1336));
    public static final NbtCodec<Double> DOUBLE = NbtCodec.create(class_419.class, class_419::new, x -> x.field_1680);
    public static final NbtCodec<String> STRING = NbtCodec.create(class_522.class, class_522::new, x -> x.field_2190);
    public static final NbtCodec<Boolean> BOOLEAN = NbtCodec.create(class_360.class, x -> new class_360((byte)(x != false ? 1 : 0)), x -> x.field_1356 != 0);
    private final Class<? extends class_187> nbtElementType;
    private final NbtEncoder<T, class_187> toNbt;
    private final NbtDecoder<T, class_187> fromNbt;

    private NbtCodec(Class<? extends class_187> nbtElementType, NbtEncoder<T, class_187> toNbt, NbtDecoder<T, class_187> fromNbt) {
        this.nbtElementType = nbtElementType;
        this.toNbt = toNbt;
        this.fromNbt = fromNbt;
    }

    static <T, E extends class_187> NbtCodec<T> create(Class<E> nbtElementType, NbtEncoder<T, E> toNbt, NbtDecoder<T, E> fromNbt) {
        return new NbtCodec<T>(nbtElementType, toNbt, fromNbt);
    }

    @Override
    public class_187 toNbt(@NotNull T object) {
        return this.toNbt.toNbt(object);
    }

    @Override
    @NotNull
    public T fromNbt(class_187 nbt) {
        if (!this.nbtElementType.isAssignableFrom(nbt.getClass())) {
            throw new IllegalArgumentException("This codec is unable to process the given NbtElement type");
        }
        return this.fromNbt.fromNbt(nbt);
    }
}

