/*
 * Decompiled with CFR 0.152.
 */
package net.zekromaster.minecraft.terminal.storage;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.class_124;
import net.minecraft.class_134;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.util.Namespace;
import net.modificationstation.stationapi.api.util.math.Direction;
import net.zekromaster.minecraft.terminal.capabilities.BlockCapability;
import net.zekromaster.minecraft.terminal.capabilities.EntityCapability;
import net.zekromaster.minecraft.terminal.capabilities.ItemCapability;
import net.zekromaster.minecraft.terminal.storage.decorators.InventoryItemStorage;
import net.zekromaster.minecraft.terminal.storage.decorators.ReadOnlyItemStorage;
import net.zekromaster.minecraft.terminal.storage.decorators.SingleSlotItemStorage;
import net.zekromaster.minecraft.terminal.storage.decorators.WriteOnlyItemStorage;
import org.jetbrains.annotations.Nullable;

public interface ItemStorage {
    public static final BlockCapability<ItemStorage, @Nullable Direction> BLOCK = BlockCapability.createSided(Namespace.MINECRAFT.id("item_storage"), ItemStorage.class);
    public static final ItemCapability<ItemStorage, Void> ITEM = ItemCapability.createVoid(Namespace.MINECRAFT.id("item_storage"), ItemStorage.class);
    public static final EntityCapability<ItemStorage, Void> ENTITY = EntityCapability.createVoid(Namespace.MINECRAFT.id("item_storage"), ItemStorage.class);

    public int slots();

    @Nullable
    public class_31 slot(int var1);

    default public int[] slotsOf(Predicate<@Nullable class_31> matcher) {
        return IntStream.range(0, this.slots()).filter(x -> matcher.test(this.slot(x))).toArray();
    }

    default public int[] slotsOf(class_31 stack) {
        return this.slotsOf((class_31 s) -> class_31.method_703((class_31)s, (class_31)stack));
    }

    default public int[] slotsOf(class_124 item) {
        if (item == null) {
            return this.slotsOf(Objects::isNull);
        }
        return this.slotsOf((class_31 s) -> s != null && s.isOf(item));
    }

    @Nullable
    public class_31 insert(int var1, class_31 var2, OperationMode var3);

    @Nullable
    default public class_31 insert(int slot, class_31 stack) {
        return this.insert(slot, stack, OperationMode.RUN);
    }

    @Nullable
    public class_31 extract(int var1, int var2, OperationMode var3);

    @Nullable
    default public class_31 extract(int slot, int amount) {
        return this.extract(slot, amount, OperationMode.RUN);
    }

    public boolean couldInsert(int var1, class_31 var2);

    public static ItemStorage of(class_134 inventory) {
        return new InventoryItemStorage<class_134>(inventory);
    }

    default public ItemStorage extractOnly() {
        return new ReadOnlyItemStorage(this);
    }

    default public ItemStorage singleSlot(int slot) {
        return new SingleSlotItemStorage(this, slot);
    }

    default public ItemStorage insertOnly() {
        return new WriteOnlyItemStorage(this);
    }

    public static enum OperationMode {
        RUN,
        SIMULATE;

    }
}

