/*
 * Decompiled with CFR 0.152.
 */
package net.zekromaster.minecraft.terminal.storage.decorators;

import java.util.Objects;
import net.minecraft.class_134;
import net.minecraft.class_31;
import net.zekromaster.minecraft.terminal.storage.ItemStorage;
import org.jetbrains.annotations.Nullable;

public class InventoryItemStorage<I extends class_134>
implements ItemStorage {
    protected final I inventory;

    public InventoryItemStorage(I inventory) {
        this.inventory = inventory;
    }

    @Override
    public int slots() {
        return this.inventory.method_948();
    }

    @Override
    @Nullable
    public class_31 slot(int slot) {
        if (slot >= this.slots()) {
            return null;
        }
        return this.inventory.method_954(slot);
    }

    @Override
    @Nullable
    public class_31 insert(int slot, class_31 stack, ItemStorage.OperationMode operationMode) {
        if (!this.couldInsert(slot, stack)) {
            return stack;
        }
        class_31 currentContents = this.slot(slot);
        int maxAmount = Math.min(stack.method_709(), this.inventory.method_953());
        class_31 retStack = stack.method_724();
        if (currentContents != null) {
            if (!currentContents.method_702(stack) || !Objects.equals(stack.getStationNbt(), currentContents.getStationNbt())) {
                return stack;
            }
            int totalAmount = currentContents.field_751 + stack.field_751;
            class_31 resultingStack = currentContents.method_724();
            resultingStack.field_751 = Math.min(totalAmount, maxAmount);
            if (operationMode == ItemStorage.OperationMode.RUN) {
                this.inventory.method_950(slot, resultingStack);
            }
            retStack.field_751 = totalAmount - resultingStack.field_751;
        } else {
            class_31 insertedStack = stack.method_724();
            insertedStack.field_751 = Math.min(maxAmount, insertedStack.field_751);
            if (operationMode == ItemStorage.OperationMode.RUN) {
                this.inventory.method_950(slot, insertedStack);
            }
            retStack.field_751 -= insertedStack.field_751;
        }
        if (retStack.field_751 > 0) {
            return retStack;
        }
        return null;
    }

    @Override
    @Nullable
    public class_31 extract(int slot, int amount, ItemStorage.OperationMode operationMode) {
        class_31 currentContents = this.slot(slot);
        if (currentContents == null) {
            return null;
        }
        class_31 extractedStack = currentContents.method_724();
        extractedStack.field_751 = Math.min(currentContents.field_751, amount);
        if (operationMode == ItemStorage.OperationMode.RUN) {
            this.inventory.method_949(slot, extractedStack.field_751);
        }
        return extractedStack;
    }

    @Override
    public boolean couldInsert(int slot, class_31 stack) {
        return slot < this.slots();
    }
}

