/*
 * Decompiled with CFR 0.152.
 */
package net.zekromaster.minecraft.terminal.storage.decorators;

import net.minecraft.class_31;
import net.zekromaster.minecraft.terminal.storage.ItemStorage;
import org.jetbrains.annotations.Nullable;

public class SingleSlotItemStorage
implements ItemStorage {
    private final ItemStorage innerStorage;
    private final int inventorySlot;

    public SingleSlotItemStorage(ItemStorage innerStorage, int slot) {
        this.innerStorage = innerStorage;
        this.inventorySlot = slot;
    }

    @Override
    public int slots() {
        return 1;
    }

    @Override
    @Nullable
    public class_31 slot(int slot) {
        if (slot != 0) {
            return null;
        }
        return this.innerStorage.slot(this.inventorySlot);
    }

    @Override
    @Nullable
    public class_31 insert(int slot, class_31 stack, ItemStorage.OperationMode operationMode) {
        if (slot != 0) {
            return null;
        }
        return this.innerStorage.insert(this.inventorySlot, stack, operationMode);
    }

    @Override
    @Nullable
    public class_31 extract(int slot, int amount, ItemStorage.OperationMode operationMode) {
        if (slot != 0) {
            return null;
        }
        return this.innerStorage.extract(slot, amount, operationMode);
    }

    @Override
    public boolean couldInsert(int slot, class_31 stack) {
        return slot == 0 && this.innerStorage.couldInsert(slot, stack);
    }
}

