package net.zekromaster.minecraft.terminal.mixin.utils;

import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_60;
import net.zekromaster.minecraft.terminal.utils.DynamicBlastProof;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_60.class)
public abstract class ExplosionMixin {

    @Redirect(
        method = "explode",
        at = @At(value = "INVOKE", target = "Lnet/minecraft/world/World;getBlockId(III)I")
    )
    int blastResistance(class_18 instance, int x, int y, int z) {
        var blastProofable = DynamicBlastProof.CAPABILITY.get(instance, x, y, z, null);
        if (blastProofable != null && blastProofable.isBlastProof()) {
            return class_17.field_1890.field_1915;
        }
        return instance.method_1776(x, y, z);
    }

}
