package net.zekromaster.minecraft.terminal.storage.decorators;

import net.minecraft.class_134;
import net.minecraft.class_31;
import net.zekromaster.minecraft.terminal.storage.ItemStorage;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

public class InventoryItemStorage<I extends class_134> implements ItemStorage {

    protected final I inventory;

    public InventoryItemStorage(I inventory) {
        this.inventory = inventory;
    }

    @Override
    public int slots() {
        return inventory.method_948();
    }

    @Override
    public @Nullable class_31 slot(int slot) {
        if (slot >= slots()) {
            return null;
        }
        return inventory.method_954(slot);
    }

    @Override
    public @Nullable class_31 insert(int slot, class_31 stack, OperationMode operationMode) {
        if (!couldInsert(slot, stack)) {
            return stack;
        }

        var currentContents = slot(slot);
        var maxAmount = Math.min(stack.method_709(), inventory.method_953());

        var retStack = stack.method_724();

        if (currentContents != null) {
            if (!currentContents.method_702(stack) || !Objects.equals(stack.getStationNbt(), currentContents.getStationNbt())) {
                return stack;
            }

            var totalAmount = currentContents.field_751 + stack.field_751;

            var resultingStack = currentContents.method_724();
            resultingStack.field_751 = Math.min(totalAmount, maxAmount);

            if (operationMode == OperationMode.RUN) {
                inventory.method_950(slot, resultingStack);
            }

            retStack.field_751 = totalAmount - resultingStack.field_751;
        } else {
            var insertedStack = stack.method_724();
            insertedStack.field_751 = Math.min(maxAmount, insertedStack.field_751);
            if (operationMode == OperationMode.RUN) {
                inventory.method_950(slot, insertedStack);
            }
            retStack.field_751 -= insertedStack.field_751;
        }

        if (retStack.field_751 > 0) {
            return retStack;
        }
        return null;
    }

    @Override
    public @Nullable class_31 extract(int slot, int amount, OperationMode operationMode) {
        var currentContents = slot(slot);

        if (currentContents == null) {
            return null;
        }

        var extractedStack = currentContents.method_724();
        extractedStack.field_751 = Math.min(currentContents.field_751, amount);
        if (operationMode == OperationMode.RUN) {
            inventory.method_949(slot, extractedStack.field_751);
        }
        return extractedStack;
    }

    @Override
    public boolean couldInsert(int slot, class_31 stack) {
        return slot < slots();
    }
}
