package net.zekromaster.minecraft.terminal.storage.decorators;

import net.minecraft.class_31;
import net.zekromaster.minecraft.terminal.storage.ItemStorage;
import org.jetbrains.annotations.Nullable;

public class SingleSlotItemStorage implements ItemStorage {

    private final ItemStorage innerStorage;
    private final int inventorySlot;

    public SingleSlotItemStorage(ItemStorage innerStorage, int slot) {
        this.innerStorage = innerStorage;
        this.inventorySlot = slot;
    }

    @Override
    public int slots() {
        return 1;
    }

    @Override
    public @Nullable class_31 slot(int slot) {
        if (slot != 0) {
            return null;
        }
        return innerStorage.slot(this.inventorySlot);
    }

    @Override
    public @Nullable class_31 insert(int slot, class_31 stack, OperationMode operationMode) {
        if (slot != 0) {
            return null;
        }
        return innerStorage.insert(inventorySlot, stack, operationMode);
    }

    @Override
    public @Nullable class_31 extract(int slot, int amount, OperationMode operationMode) {
        if (slot != 0) {
            return null;
        }
        return innerStorage.extract(slot, amount, operationMode);
    }

    @Override
    public boolean couldInsert(int slot, class_31 stack) {
        return slot == 0 && innerStorage.couldInsert(slot, stack);
    }
}
