package net.zekromaster.minecraft.terminal.storage.decorators;

import net.minecraft.class_31;
import net.zekromaster.minecraft.terminal.storage.ItemStorage;
import org.jetbrains.annotations.Nullable;

public class WriteOnlyItemStorage implements ItemStorage {

    private final ItemStorage innerStorage;

    public WriteOnlyItemStorage(ItemStorage innerStorage) {
        this.innerStorage = innerStorage;
    }

    @Override
    public int slots() {
        return innerStorage.slots();
    }

    @Override
    public @Nullable class_31 slot(int slot) {
        return innerStorage.slot(slot);
    }

    @Override
    public @Nullable class_31 insert(int slot, class_31 stack, OperationMode operationMode) {
        return innerStorage.insert(slot, stack, operationMode);
    }

    @Override
    public @Nullable class_31 extract(int slot, int amount, OperationMode operationMode) {
        return null;
    }

    @Override
    public boolean couldInsert(int slot, class_31 stack) {
        return innerStorage.couldInsert(slot, stack);
    }
}
