package net.zekromaster.minecraft.terminal.storage.impl;

import net.mine_diver.unsafeevents.listener.EventListener;
import net.minecraft.class_137;
import net.minecraft.class_138;
import net.minecraft.class_225;
import net.minecraft.class_4;
import net.zekromaster.minecraft.terminal.capabilities.CapabilityEvents;
import net.zekromaster.minecraft.terminal.storage.ItemStorage;
import net.zekromaster.minecraft.terminal.storage.decorators.InventoryItemStorage;

public class CapabilitiesListener {

    @EventListener
    public void registerBlockCapabilities(CapabilityEvents.RegisterBlockEntityCapabilitiesEvent event) {
        event.register(
            ItemStorage.BLOCK,
            (be, direction) -> ItemStorage.of((class_225) be),
            "Chest"
        );

        event.register(
            ItemStorage.BLOCK,
            (be, direction) -> {
                var fullStorage = new FurnaceItemStorage((class_138) be);

                if (direction == null) {
                    return fullStorage;
                }
                return switch (direction) {
                    case DOWN -> fullStorage.singleSlot(2).extractOnly();
                    case UP -> fullStorage.singleSlot(0);
                    default ->  fullStorage.singleSlot(1);
                };
            },
            "Furnace"
        );

        event.register(
            ItemStorage.BLOCK,
            (be, direction) -> new JukeboxItemStorage((class_4) be),
            "RecordPlayer"
        );

        event.register(
            ItemStorage.BLOCK,
            (be, direction) -> new InventoryItemStorage<>((class_137) be),
            "Trap"
        );

    }

}
