package net.zekromaster.minecraft.terminal.storage.impl;

import net.minecraft.class_31;
import net.minecraft.class_4;
import net.minecraft.class_449;
import net.zekromaster.minecraft.terminal.storage.ItemStorage;
import org.jetbrains.annotations.Nullable;

public class JukeboxItemStorage implements ItemStorage {
    private final class_4 jukebox;

    public JukeboxItemStorage(class_4 jukebox) {
        this.jukebox = jukebox;
    }

    @Override
    public int slots() {
        return 1;
    }

    @Override
    public @Nullable class_31 slot(int slot) {
        if (slot != 0) {
            return null;
        }
        return new class_31(jukebox.field_4, 1, 0);
    }

    @Override
    public @Nullable class_31 insert(int slot, class_31 stack, OperationMode operationMode) {
        if (!couldInsert(slot, stack)) {
            return stack;
        }

        if (jukebox.field_4 > 0) {
            return stack;
        }

        if (operationMode == OperationMode.RUN) {
            jukebox.field_4 = stack.method_694().field_461;
            jukebox.method_947();
            jukebox.field_1238.method_215(jukebox.field_1239, jukebox.field_1240, jukebox.field_1241, 1);
        }

        var retStack = stack.method_724();
        retStack.field_751--;
        return retStack;
    }

    @Override
    public @Nullable class_31 extract(int slot, int amount, OperationMode operationMode) {
        if (jukebox.field_4 == 0 || slot != 0 || amount < 1) {
            return null;
        }
        var previousId = jukebox.field_4;


        jukebox.field_1238.method_230(1005, jukebox.field_1239, jukebox.field_1240, jukebox.field_1241, 0);
        jukebox.field_1238.method_179(null, jukebox.field_1239, jukebox.field_1240, jukebox.field_1241);
        jukebox.field_4 = 0;
        jukebox.method_947();
        jukebox.field_1238.method_215(jukebox.field_1239, jukebox.field_1240, jukebox.field_1241, 0);

        return new class_31(
            previousId,
            1,
            0
        );
    }

    @Override
    public boolean couldInsert(int slot, class_31 stack) {
        return slot == 0 && stack.method_694() instanceof class_449;
    }
}
