package net.zekromaster.minecraft.terminal.utils;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_55;

class BlockEntityPropertyBlastProof<B extends class_55> implements DynamicBlastProof {

    private final B blockEntity;
    private final Function<B, Boolean> getter;
    private final BiConsumer<B, Boolean> setter;

    BlockEntityPropertyBlastProof(B blockEntity, Function<B, Boolean> getter, BiConsumer<B, Boolean> setter) {
        this.blockEntity = blockEntity;
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public boolean isBlastProof() {
        return this.getter.apply(blockEntity);
    }

    @Override
    public void setBlastProof(boolean value) {
        this.setter.accept(blockEntity, value);
    }
}
