package net.zekromaster.minecraft.terminal.utils;

import net.minecraft.class_18;
import net.minecraft.class_339;
import net.modificationstation.stationapi.api.state.property.Property;

class BlockStateBasedBlastProof implements DynamicBlastProof {
    private final class_18 world;
    private final class_339 pos;
    private final Property<Boolean> property;

    BlockStateBasedBlastProof(class_18 world, class_339 pos, Property<Boolean> property) {
        this.world = world;
        this.pos = pos;
        this.property = property;
    }

    @Override
    public boolean isBlastProof() {
        var blockState = world.getBlockState(pos);
        return blockState.contains(property) && blockState.get(property);
    }

    @Override
    public void setBlastProof(boolean value) {
        var blockState = world.getBlockState(pos);
        if (blockState.contains(property)) {
            world.setBlockStateWithNotify(pos, blockState.with(property, value));
            world.method_246(pos.field_2100, pos.field_2101, pos.field_2102);
        }
    }

}
