/*
 * Decompiled with CFR 0.152.
 */
package net.zekromaster.minecraft.terminal.attachments;

import java.util.function.Consumer;
import java.util.function.Function;
import net.zekromaster.minecraft.terminal.attachments.AttachmentType;
import org.jetbrains.annotations.Nullable;

public interface AttachmentStore {
    default public <T> T getData(AttachmentType<T> attachmentType) {
        if (!this.hasData(attachmentType)) {
            this.setData(attachmentType, attachmentType.defaultValue());
        }
        return this.getDataOrNull(attachmentType);
    }

    @Nullable
    public <T> T getDataOrNull(AttachmentType<T> var1);

    public <T> void setData(AttachmentType<T> var1, T var2);

    public boolean hasData(AttachmentType<?> var1);

    default public <T> void mutateData(AttachmentType<T> attachmentType, Function<T, T> mutation) {
        this.setData(attachmentType, mutation.apply(this.getData(attachmentType)));
    }

    default public <T> void mutateData(AttachmentType<T> attachmentType, Consumer<T> mutation) {
        this.mutateData(attachmentType, (T a) -> {
            mutation.accept(a);
            return a;
        });
    }
}

