/*
 * Decompiled with CFR 0.152.
 */
package net.zekromaster.minecraft.terminal.attachments;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.modificationstation.stationapi.api.util.Identifier;
import org.jetbrains.annotations.Nullable;

public final class AttachmentType<T> {
    private final Supplier<T> defaultValue;
    public final Class<T> clazz;
    public final Identifier identifier;
    @Nullable
    public final Codec<T> codec;

    private AttachmentType(Identifier identifier, Class<T> clazz, Supplier<T> defaultValue, @Nullable Codec<T> codec) {
        this.identifier = identifier;
        this.clazz = clazz;
        this.defaultValue = defaultValue;
        this.codec = codec;
    }

    public T defaultValue() {
        return this.defaultValue.get();
    }

    public static <T> AttachmentTypeBuilder<T> create(Identifier identifier, Class<T> clazz, Supplier<T> defaultValue) {
        return new AttachmentTypeBuilder<T>(identifier, clazz, defaultValue);
    }

    public static <T> AttachmentTypeBuilder<T> create(Identifier identifier, Class<T> clazz, T defaultValue) {
        return AttachmentType.create(identifier, clazz, Suppliers.ofInstance(defaultValue));
    }

    public static final class AttachmentTypeBuilder<T> {
        private final Class<T> clazz;
        private final Identifier identifier;
        private final Supplier<T> defaultValue;
        @Nullable
        private Codec<T> codec;

        private AttachmentTypeBuilder(Identifier identifier, Class<T> clazz, Supplier<T> defaultValue) {
            this.identifier = identifier;
            this.clazz = clazz;
            this.defaultValue = defaultValue;
            this.codec = null;
        }

        public AttachmentTypeBuilder<T> codec(@Nullable Codec<T> codec) {
            this.codec = codec;
            return this;
        }

        public AttachmentType<T> build() {
            return new AttachmentType<T>(this.identifier, this.clazz, this.defaultValue, this.codec);
        }
    }
}

