/*
 * Decompiled with CFR 0.152.
 */
package net.zekromaster.minecraft.terminal.attachments;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_187;
import net.minecraft.class_55;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.nbt.NbtOps;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.mixin.nbt.NbtCompoundAccessor;
import net.zekromaster.minecraft.terminal.attachments.AttachmentStore;
import net.zekromaster.minecraft.terminal.attachments.AttachmentType;
import net.zekromaster.minecraft.terminal.attachments.AttachmentTypeRegistry;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Unique;

public class SimpleAttachmentStore
implements AttachmentStore {
    @Unique
    private static final Logger LOG = LoggerFactory.getLogger(class_55.class);
    private final Map<AttachmentType<?>, Object> attachments = new HashMap();

    @Override
    @Nullable
    public <T> T getDataOrNull(AttachmentType<T> attachmentType) {
        return (T)this.attachments.get(attachmentType);
    }

    @Override
    public <T> void setData(AttachmentType<T> attachmentType, T data) {
        if (data == null) {
            this.attachments.remove(attachmentType);
        } else {
            this.attachments.put(attachmentType, data);
        }
    }

    @Override
    public boolean hasData(AttachmentType<?> attachmentType) {
        return this.attachments.containsKey(attachmentType);
    }

    public class_187 writeToNbt() {
        Set<Map.Entry<AttachmentType<?>, Object>> allAttachments = this.attachments.entrySet();
        if (allAttachments.isEmpty()) {
            return new class_8();
        }
        class_187 nbtAttachments = NbtOps.INSTANCE.empty();
        for (Map.Entry<AttachmentType<?>, Object> attachment : allAttachments) {
            if (attachment.getKey().codec == null) continue;
            Codec codec = attachment.getKey().codec.fieldOf(attachment.getKey().identifier.toString()).codec();
            Optional res = codec.encode(attachment.getValue(), (DynamicOps)NbtOps.INSTANCE, (Object)nbtAttachments).result();
            nbtAttachments = (class_187)res.orElseThrow(() -> new Error("Couldn't serialise attachment correctly"));
        }
        return nbtAttachments;
    }

    public void readFromNbt(class_8 nbt) {
        Map allAttachments = ((NbtCompoundAccessor)nbt).stationapi$getEntries();
        for (Map.Entry attachmentNbt : allAttachments.entrySet()) {
            AttachmentType type = (AttachmentType)AttachmentTypeRegistry.INSTANCE.get(Identifier.of((String)((String)attachmentNbt.getKey())));
            if (type == null) {
                LOG.warn("Invalid attachment {} on block entity. It won't be loaded and will be lost on next world save.", attachmentNbt.getKey());
                continue;
            }
            if (type.codec == null) {
                LOG.warn("Non-deserialisable attachment {} on block entity. It won't be loaded and will be lost on next world save.", attachmentNbt.getKey());
                continue;
            }
            DataResult value = type.codec.decode((DynamicOps)NbtOps.INSTANCE, (Object)((class_187)attachmentNbt.getValue()));
            this.setData(type, (Pair)value.getOrThrow(false, t -> {}));
        }
    }
}

