/*
 * Decompiled with CFR 0.152.
 */
package net.zekromaster.minecraft.terminal.capabilities;

import net.mine_diver.unsafeevents.Event;
import net.minecraft.class_124;
import net.minecraft.class_17;
import net.zekromaster.minecraft.terminal.capabilities.BlockCapability;
import net.zekromaster.minecraft.terminal.capabilities.EntityCapability;
import net.zekromaster.minecraft.terminal.capabilities.ItemCapability;

public interface CapabilityEvents {

    public static class RegisterEntityCapabilitiesEvent
    extends Event {
        public <T, CTX> void register(EntityCapability<T, CTX> capability, EntityCapability.EntityCapabilityHandler<T, CTX> handler, String ... entities) {
            for (String entity : entities) {
                capability.handlers.put((Object)entity, handler);
            }
        }

        public <T, CTX> void registerFallback(EntityCapability<T, CTX> capability, EntityCapability.EntityCapabilityHandler<T, CTX> handler) {
            capability.fallbacks.add(handler);
        }
    }

    public static class RegisterBlockEntityCapabilitiesEvent
    extends Event {
        public <T, CTX> void register(BlockCapability<T, CTX> capability, BlockCapability.BlockEntityCapabilityHandler<T, CTX> handler, String ... blockEntities) {
            for (String be : blockEntities) {
                capability.blockEntityHandlers.put((Object)be, handler);
            }
        }

        public <T, CTX> void registerFallback(BlockCapability<T, CTX> capability, BlockCapability.BlockEntityCapabilityHandler<T, CTX> handler) {
            capability.blockEntityFallbacks.add(handler);
        }
    }

    public static class RegisterBlockCapabilitiesEvent
    extends Event {
        public <T, CTX> void register(BlockCapability<T, CTX> capability, BlockCapability.BlockCapabilityHandler<T, CTX> handler, class_17 ... blocks) {
            for (class_17 block : blocks) {
                capability.blockHandlers.put((Object)block, handler);
            }
        }

        public <T, CTX> void registerFallback(BlockCapability<T, CTX> capability, BlockCapability.BlockCapabilityHandler<T, CTX> handler) {
            capability.blockFallbacks.add(handler);
        }
    }

    public static class RegisterItemCapabilitiesEvent
    extends Event {
        public <T, CTX> void register(ItemCapability<T, CTX> capability, ItemCapability.ItemCapabilityHandler<T, CTX> handler, class_124 ... items) {
            for (class_124 item : items) {
                capability.handlers.put((Object)item, handler);
            }
        }

        public <T, CTX> void registerFallback(ItemCapability<T, CTX> capability, ItemCapability.ItemCapabilityHandler<T, CTX> handler) {
            capability.fallbacks.add(handler);
        }
    }
}

