/*
 * Decompiled with CFR 0.152.
 */
package net.zekromaster.minecraft.terminal.capabilities;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import net.minecraft.class_206;
import net.minecraft.class_57;
import net.modificationstation.stationapi.api.util.Identifier;
import org.jetbrains.annotations.Nullable;

public final class EntityCapability<T, CTX> {
    final Multimap<String, EntityCapabilityHandler<T, CTX>> handlers = ArrayListMultimap.create();
    final ArrayList<EntityCapabilityHandler<T, CTX>> fallbacks = new ArrayList();
    public final Identifier identifier;
    public final Class<T> clazz;
    public final Class<CTX> ctxClass;

    private EntityCapability(Identifier identifier, Class<T> clazz, Class<CTX> ctxClass) {
        this.identifier = identifier;
        this.clazz = clazz;
        this.ctxClass = ctxClass;
    }

    public static <T, CTX> EntityCapability<T, CTX> create(Identifier identifier, Class<T> clazz, Class<CTX> ctxClass) {
        return new EntityCapability<T, CTX>(identifier, clazz, ctxClass);
    }

    public static <T> EntityCapability<T, Void> createVoid(Identifier identifier, Class<T> clazz) {
        return new EntityCapability<T, Void>(identifier, clazz, Void.class);
    }

    @Nullable
    public T get(class_57 entity, CTX ctx) {
        Object value;
        for (EntityCapabilityHandler entityCapabilityHandler : this.handlers.get((Object)class_206.method_734((class_57)entity))) {
            value = entityCapabilityHandler.get(entity, ctx);
            if (value == null) continue;
            return value;
        }
        for (EntityCapabilityHandler entityCapabilityHandler : this.fallbacks) {
            value = entityCapabilityHandler.get(entity, ctx);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @FunctionalInterface
    public static interface EntityCapabilityHandler<T, CTX> {
        public T get(class_57 var1, CTX var2);
    }
}

